<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class User extends My_Controller {

    function __construct() {
        parent::__construct();
    }

    public function user_login() {
        $email = $this->Validator('email');
        $password = base64_encode($this->Validator('password'));
        $check = $this->User_model->login_check($email, $password);

        if (!empty($check)) {


            $this->success_response_body('', true, array('User' => $check));
        } else {
            $this->error_response_body(NOT_LOGIN);
        }
    }

    public function user_change_password() {
        $id = $this->Validator('user_id');
        $old_password = $this->Validator('old_password');
        $new_password = $this->Validator('new_password');
        $validate_user = $this->User_model->check_user($id, $old_password);

        if (!empty($validate_user)) {
            $dataArray = array(
                'password' => base64_encode($new_password)
            );
            $result = $this->User_model->update_profile($dataArray, $id);
            if ($result) {
                $this->success_response_body(SCC_UPDATED_MSG);
            } else {
                $this->error_response_body(ERR_DATA_PROCESSING_ERROR);
            }
        } else {
            $this->error_response_body(ERR_SOMETHING_WRONG);
        }
    }

    public function user_forgot_password() {
        $email = $this->Validator('email');
        $result = $this->User_model->check_email($email);
        if ($result == TRUE) {
            $lst = $this->generateRandomString(5);
            $rst = $this->generateRandomString(5);
            $curTime = base64_encode(date('Y-m-d H:i:s'));
            $userId = $result[0]->id;
            $encodeuser = $lst . base64_encode($userId) . $rst;
            $url = base_url() . 'Forgot/reset_password/' . $encodeuser . "/" . $curTime;
            $toRepArray = array('[!email!]', '[!url!]', '[!img!]');
            $fromRepArray = array(
                $email,
                $url,
                LOGO_IMG
            );
            $subject = "Forgotten password reset";
            $message_templete = $this->load->view('email/forgot_password.html', '', true);
            $message = str_replace($toRepArray, $fromRepArray, $message_templete);
            $sentmail = $this->send_email($email, $subject, $message);
            if ($sentmail) {
                $this->success_response_body('Password reset link send to your mail.');
            } else {
                $this->error_response_body('Mail not sent.');
            }
        } else {
            $this->error_response_body('Your email not exist.');
        }
    }

    public function generateRandomString($val) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $val; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    public function get_history_culture() {
        $lang = $this->getValue('lang');
        $data = $this->User_model->get_history_culture($lang);
        foreach ($data as $row) {
            $result['id'] = $row->id;
            $result['title'] = $row->title;
            $result['subTitle'] = $row->subTitle;
            $result['description'] = $row->description;
            $result['images'] = json_decode($row->images);
            $result['audio'] = $row->audio;
            $result['address'] = $row->address;
            $result['website'] = $row->website;
            $result['status'] = $row->status;
            $detail[] = $result;
        }


//                $result[0]->images = json_decode($result[0]->images);
        if ($data) {
            $this->success_response_body('', true, array('Detail' => $detail));
        } else {
            $this->error_response_body(ERR_DATA_PROCESSING_ERROR);
        }
    }

    public function get_attraction() {
        $lang = $this->getValue('lang');
        $data = $this->User_model->get_attraction($lang);
        foreach ($data as $row) {
            $result['id'] = $row->id;
            $result['title'] = $row->title;
            $result['subTitle'] = $row->subTitle;
            $result['description'] = $row->description;
            $result['images'] = json_decode($row->images);
            $result['audio'] = $row->audio;
            $result['address'] = $row->address;
            $result['website'] = $row->website;
            $result['status'] = $row->status;
            $detail[] = $result;
        }


//                $result[0]->images = json_decode($result[0]->images);
        if ($data) {
            $this->success_response_body('', true, array('Detail' => $detail));
        } else {
            $this->error_response_body(ERR_DATA_PROCESSING_ERROR);
        }
    }

    public function get_accommodation() {
        $lang = $this->getValue('lang');
        $data = $this->User_model->get_accommodation($lang);
        foreach ($data as $row) {
            $result['id'] = $row->id;
            $result['title'] = $row->title;
            $result['subTitle'] = $row->subTitle;
            $result['description'] = $row->description;
            $result['images'] = json_decode($row->images);
            $result['address'] = $row->address;
            $result['cost'] = $row->cost;
            $result['phone'] = $row->phone;
            $result['email'] = $row->email;
            $result['website'] = $row->website;
            $result['status'] = $row->status;
            $detail[] = $result;
        }
        if ($data) {
            $this->success_response_body('', true, array('Detail' => $detail));
        } else {
            $this->error_response_body(ERR_DATA_PROCESSING_ERROR);
        }
    }

    public function get_gastronomy() {
        $lang = $this->getValue('lang');
        $data = $this->User_model->get_gastronomy($lang);
        foreach ($data as $row) {
            $result['id'] = $row->id;
            $result['title'] = $row->title;
            $result['subTitle'] = $row->subTitle;
            $result['description'] = $row->description;
            $result['images'] = json_decode($row->images);
            $result['address'] = $row->address;
            $result['cost'] = $row->cost;
            $result['phone'] = $row->phone;
            $result['email'] = $row->email;
            $result['website'] = $row->website;
            $result['status'] = $row->status;
            $detail[] = $result;
        }
        if ($data) {
            $this->success_response_body('', true, array('Detail' => $detail));
        } else {
            $this->error_response_body(ERR_DATA_PROCESSING_ERROR);
        }
    }

    public function get_bars_nightclub() {
        $lang = $this->getValue('lang');
        $data = $this->User_model->get_bars_nightclub($lang);
        foreach ($data as $row) {
            $result['id'] = $row->id;
            $result['title'] = $row->title;
            $result['subTitle'] = $row->subTitle;
            $result['description'] = $row->description;
            $result['images'] = json_decode($row->images);
            $result['address'] = $row->address;
            $result['cost'] = $row->cost;
            $result['phone'] = $row->phone;
            $result['email'] = $row->email;
            $result['website'] = $row->website;
            $result['status'] = $row->status;
            $detail[] = $result;
        }
        if ($data) {
            $this->success_response_body('', true, array('Detail' => $detail));
        } else {
            $this->error_response_body(ERR_DATA_PROCESSING_ERROR);
        }
    }

    public function get_private_tours() {
        $lang = $this->getValue('lang');
        $data = $this->User_model->get_private_tours($lang);
        foreach ($data as $row) {
            $result['id'] = $row->id;
            $result['title'] = $row->title;
            $result['subTitle'] = $row->subTitle;
            $result['description'] = $row->description;
            $result['images'] = json_decode($row->images);
            $result['address'] = $row->address;
            $result['cost'] = $row->cost;
            $result['phone'] = $row->phone;
            $result['email'] = $row->email;
            $result['website'] = $row->website;
            $result['status'] = $row->status;
            $detail[] = $result;
        }
        if ($data) {
            $this->success_response_body('', true, array('Detail' => $detail));
        } else {
            $this->error_response_body(ERR_DATA_PROCESSING_ERROR);
        }
    }

    public function get_activities() {
        $lang = $this->getValue('lang');
        $data = $this->User_model->get_activities($lang);
        foreach ($data as $row) {
            $result['id'] = $row->id;
            $result['title'] = $row->title;
            $result['subTitle'] = $row->subTitle;
            $result['description'] = $row->description;
            $result['images'] = json_decode($row->images);
            $result['address'] = $row->address;
            $result['cost'] = $row->cost;
            $result['phone'] = $row->phone;
            $result['email'] = $row->email;
            $result['website'] = $row->website;
            $result['status'] = $row->status;
            $detail[] = $result;
        }
        if ($data) {
            $this->success_response_body('', true, array('Detail' => $detail));
        } else {
            $this->error_response_body(ERR_DATA_PROCESSING_ERROR);
        }
    }

    public function get_transport() {
        $lang = $this->getValue('lang');
        $data = $this->User_model->get_transport($lang);
        foreach ($data as $row) {
            $result['id'] = $row->id;
            $result['title'] = $row->title;
            $result['subTitle'] = $row->subTitle;
            $result['description'] = $row->description;
            $result['images'] = json_decode($row->images);
            $result['address'] = $row->address;
            $result['cost'] = $row->cost;
            $result['phone'] = $row->phone;
            $result['email'] = $row->email;
            $result['website'] = $row->website;
            $result['status'] = $row->status;
            $detail[] = $result;
        }
        if ($data) {
            $this->success_response_body('', true, array('Detail' => $detail));
        } else {
            $this->error_response_body(ERR_DATA_PROCESSING_ERROR);
        }
    }

    public function get_health_care() {
        $lang = $this->getValue('lang');
        $data = $this->User_model->get_health_care($lang);
        foreach ($data as $row) {
            $result['id'] = $row->id;
            $result['title'] = $row->title;
            $result['subTitle'] = $row->subTitle;
            $result['description'] = $row->description;
            $result['images'] = json_decode($row->images);
            $result['address'] = $row->address;
            $result['cost'] = $row->cost;
            $result['phone'] = $row->phone;
            $result['email'] = $row->email;
            $result['website'] = $row->website;
            $result['status'] = $row->status;
            $detail[] = $result;
        }
        if ($data) {
            $this->success_response_body('', true, array('Detail' => $detail));
        } else {
            $this->error_response_body(ERR_DATA_PROCESSING_ERROR);
        }
    }

    public function get_shopping() {
        $lang = $this->getValue('lang');
        $data = $this->User_model->get_shopping($lang);
        foreach ($data as $row) {
            $result['id'] = $row->id;
            $result['title'] = $row->title;
            $result['subTitle'] = $row->subTitle;
            $result['description'] = $row->description;
            $result['images'] = json_decode($row->images);
            $result['address'] = $row->address;
            $result['cost'] = $row->cost;
            $result['phone'] = $row->phone;
            $result['email'] = $row->email;
            $result['website'] = $row->website;
            $result['status'] = $row->status;
            $detail[] = $result;
        }
        if ($data) {
            $this->success_response_body('', true, array('Detail' => $detail));
        } else {
            $this->error_response_body(ERR_DATA_PROCESSING_ERROR);
        }
    }

    public function get_bank() {
        $lang = $this->getValue('lang');
        $data = $this->User_model->get_bank($lang);
        foreach ($data as $row) {
            $result['id'] = $row->id;
            $result['title'] = $row->title;
            $result['subTitle'] = $row->subTitle;
            $result['description'] = $row->description;
            $result['images'] = json_decode($row->images);
            $result['address'] = $row->address;
            $result['cost'] = $row->cost;
            $result['phone'] = $row->phone;
            $result['email'] = $row->email;
            $result['website'] = $row->website;
            $result['status'] = $row->status;
            $detail[] = $result;
        }
        if ($data) {
            $this->success_response_body('', true, array('Detail' => $detail));
        } else {
            $this->error_response_body(ERR_DATA_PROCESSING_ERROR);
        }
    }

    public function get_public_institution() {
        $lang = $this->getValue('lang');
        $data = $this->User_model->get_public_institution($lang);
        foreach ($data as $row) {
            $result['id'] = $row->id;
            $result['title'] = $row->title;
            $result['subTitle'] = $row->subTitle;
            $result['description'] = $row->description;
            $result['images'] = json_decode($row->images);
            $result['address'] = $row->address;
            $result['cost'] = $row->cost;
            $result['phone'] = $row->phone;
            $result['email'] = $row->email;
            $result['website'] = $row->website;
            $result['status'] = $row->status;
            $detail[] = $result;
        }
        if ($data) {
            $this->success_response_body('', true, array('Detail' => $detail));
        } else {
            $this->error_response_body(ERR_DATA_PROCESSING_ERROR);
        }
    }

    public function get_news() {
        $lang = $this->getValue('lang');
        $data = $this->User_model->get_news($lang);
        foreach ($data as $row) {
            $result['id'] = $row->id;
            $result['title'] = $row->title;
            $result['description'] = $row->description;
            $result['images'] = json_decode($row->images);
            $result['news_date'] = $row->news_date;
            if($lang == 'en')
            {
                $result['read_time'] = $row->read_time." Minutes reading";
            }
            else if($lang == 'hr')
            {
                $result['read_time'] = $row->read_time." Minuta čitanja";
            }
            else if($lang == 'gr')
            {
                $result['read_time'] = $row->read_time." Minuten lessen";
            }
            
            $result['status'] = $row->status;
            $detail[] = $result;
        }
        if ($data) {
            $this->success_response_body('', true, array('Detail' => $detail));
        } else {
            $this->error_response_body(ERR_DATA_PROCESSING_ERROR);
        }
    }

    public function get_event() {
        $lang = $this->getValue('lang');
        $data = $this->User_model->get_event($lang);
        foreach ($data as $row) {
            $result['id'] = $row->id;
            $result['title'] = $row->title;
            $result['description'] = $row->description;
            $result['images'] = json_decode($row->images);
            $result['event_date'] = $row->event_date;
            $result['status'] = $row->status;
            $detail[] = $result;
        }
        if ($data) {
            $this->success_response_body('', true, array('Detail' => $detail));
        } else {
            $this->error_response_body(ERR_DATA_PROCESSING_ERROR);
        }
    }

    public function add_wishlist() {
        $device_id = $this->Validator('device_id');
        $device_type = $this->Validator('device_type');
        $info_id = $this->Validator('info_id');
        $info_type = $this->Validator('info_type');
        $check_device = $this->User_model->check_device($device_id, $info_id, $info_type);
        if (!empty($check_device)) {
            $this->User_model->delete_wishlist($device_id, $info_id, $info_type);
            $this->success_response_body(SCC_REMOVE_WISHLIST);
        } else {
            $data = array(
                'device_id' => $device_id,
                'device_type' => $device_type,
                'info_id' => $info_id,
                'info_type' => $info_type,
                'status' => 1,
                'created' => date('Y-m-d H:i:s')
            );
            $result = $this->User_model->add_wishlist($data);
            if (!empty($result)) {
                $this->success_response_body(SCC_ADDED_WISHLIST);
            } else {
                $this->error_response_body(ERR_DATA_PROCESSING_ERROR);
            }
        }
    }

    public function get_wishlist() {
        $lang = $this->getValue('lang');
        $device_id = $this->Validator('device_id');
        $data = $this->User_model->get_wishlist($device_id);
        $detail = array();
        foreach ($data as $data) {
            $info_id = $data->info_id;
            $info_type = $data->info_type;


            $result = $this->User_model->get_new_wishlist($info_id, $info_type, $lang);
            foreach ($result as $row) {

                if ($info_type == 'history_culture') {
                    $data_new['id'] = $row->id;
                    $data_new['title'] = $row->title;
                    $data_new['subTitle'] = $row->subTitle;
                    $data_new['description'] = $row->description;
                    $data_new['images'] = json_decode($row->images);
                    $data_new['audio'] = $row->audio;
                    $data_new['address'] = $row->address;
                    $data_new['website'] = $row->website;
                    $data_new['status'] = $row->status;
                    $data_new['info_type'] = $info_type;
                    $detail[] = $data_new;
                } else if ($info_type == 'attraction') {
                    $data_new['id'] = $row->id;
                    $data_new['title'] = $row->title;
                    $data_new['subTitle'] = $row->subTitle;
                    $data_new['description'] = $row->description;
                    $data_new['images'] = json_decode($row->images);
                    $data_new['audio'] = $row->audio;
                    $data_new['address'] = $row->address;
                    $data_new['website'] = $row->website;
                    $data_new['status'] = $row->status;
                    $data_new['info_type'] = $info_type;
                    $detail[] = $data_new;
                } else if ($info_type == 'news') {
                    $data_new['id'] = $row->id;
                    $data_new['title'] = $row->title;
                    $data_new['description'] = $row->description;
                    $data_new['images'] = json_decode($row->images);
                    $data_new['news_date'] = $row->news_date;
                    $data_new['read_time'] = $row->read_time." minutes read";
                    $data_new['status'] = $row->status;
                    $data_new['info_type'] = $info_type;
                    $detail[] = $data_new;
                } else if ($info_type == 'event') {
                    $data_new['id'] = $row->id;
                    $data_new['title'] = $row->title;
                    $data_new['description'] = $row->description;
                    $data_new['images'] = json_decode($row->images);
                    $data_new['news_date'] = $row->news_date;
                    $data_new['status'] = $row->status;
                    $data_new['info_type'] = $info_type;
                    $detail[] = $data_new;
                }  else {
                    $data_new['id'] = $row->id;
                    $data_new['title'] = $row->title;
                    $data_new['subTitle'] = $row->subTitle;
                    $data_new['description'] = $row->description;
                    $data_new['images'] = json_decode($row->images);
                    $data_new['address'] = $row->address;
                    $data_new['cost'] = $row->cost;
                    $data_new['phone'] = $row->phone;
                    $data_new['email'] = $row->email;
                    $data_new['website'] = $row->website;
                    $data_new['status'] = $row->status;
                    $data_new['info_type'] = $info_type;
                    $detail[] = $data_new;
                }
            }
        }
//             $info['title'] = $result->title_.$lang;
        if ($detail) {
            $this->success_response_body('', true, array('Detail' => $detail));
        } else {
            $this->error_response_body(ERR_NOT_FOUND);
        }
    }

}
